#--------------------------------------------------------------------------
# Title:        Generated Configuration File
# Application:  IPTV Quality of Experience
#--------------------------------------------------------------------------
#  Copyright (C) 2006 Agilent Technologies
#
#  All copies of this program, whether in whole or in part, and whether
#  modified or not, must display this and all other embedded copyright
#  and ownership notices in full.
#--------------------------------------------------------------------------
# Sample software conditions of use:
#
#  This software is provided as an example. It is distributed in the hope
#  that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#--------------------------------------------------------------------------
# Synopsis:
#   Applications obtain their parameter settings by loading an external
#   configuration file using the Tcl "source" command.
#
#   This file can be generated by the associated GUI component, generated
#   by a regression test manager or created by hand.
#
# Assumptions:
#   - The test session exists
#   - The required ports have been added to the session and configured
#     to the point where L3 activity is possible (e.g. lasers on, L2 link
#     up and where required, SUT addresses assigned).
#
#--------------------------------------------------------------------------
# Organisation:
#   Ordered in the following groups
#       - mandatory parameters
#       - application specific parameters
#--------------------------------------------------------------------------

#==========================================================================
#   M a n d a t o r y   P a r a m e t e r s
#==========================================================================

namespace eval TestApp {

    # Initialise arrays
    array set appCfg \
        [list \
            agtConnectionHandle        "0" \
            agtIsNewSession            "0" \
            agtServerName              "LocalHost" \
            agtSessionHandle           "1" \
            agtSessionLabel            "Administrator" \
            agtSessionMode             "AGT_SESSION_ONLINE" \
            agtSessionType             "RouterTester900" \
            agtSessionVersion          "6.9 Internal Release" \
            agtVersion                 "0.0" \
            appFileName                "C:/Program Files/Agilent/N2X/ProductivityAdvantage/Applications/RouterTester900/IpTv/IPTV Quality of Experience/IPTV Quality of Experience.app.tcl" \
            configFileName             "C:/Program Files/Agilent/N2X/ProductivityAdvantage/UserData/IpTv/config/AeTraining_IptvPA_Group3.tcl" \
            diagramFileName            "C:/Program Files/Agilent/N2X/ProductivityAdvantage/Applications/RouterTester900/IpTv/IPTV Quality of Experience/IPTV Quality of Experience.diagram.gif" \
            helpFileName               "C:/Program Files/Agilent/N2X/ProductivityAdvantage/Applications/RouterTester900/IpTv/IPTV Quality of Experience/IPTV Quality of Experience.help" \
            logDir                     "C:/Program Files/Agilent/N2X/ProductivityAdvantage/UserData/IpTv/log" \
            logFileId                  "0" \
            logFileName                "log.IPTV Quality of Experience" \
            multimediaDir              "C:/Program Files/Agilent/N2X/RouterTester900/Multimedia/Clips" \
            qtConfigFileDir            "C:/Program Files/Agilent/N2X/ProductivityAdvantage/UserData/IpTv/config" \
            qtLibDir                   "C:/Program Files/Agilent/N2X/QuickTest/lib" \
            qtRootDir                  "C:/Program Files/Agilent/N2X/QuickTest" \
            reportDir                  "C:/Program Files/Agilent/N2X/ProductivityAdvantage/UserData/IpTv/report" \
            reportFileId               "0" \
            reportFileName             "report.IPTV Quality of Experience" \
            reportFormat               "TEXT" \
            scriptFileName             "IPTV Quality of Experience.gui.tcl" \
            scriptTitle                "IPTV Quality of Experience" \
            scriptVersion              "2.04" \
            sutInfo                    "Router: X, Software: Y" \
            userInfo                   "Administrator" \
        ] 
}

#==========================================================================
#   A p p l i c a t i o n   S p e c i f i c   P a r a m e t e r s
#==========================================================================

namespace eval TestApp {

    # Initialise arrays
    array set appData \
        [list \
            ENABLE_COLUMN              "0" \
            PC_COLUMN                  "4" \
            PHONE_COLUMN               "3" \
            POOL_COLUMN                "1" \
            PORT_COLUMN                "1" \
            PORT_TYPE_COLUMN           "2" \
            TYPE_COLUMN                "0" \
            bkgdTxBandwidth            "50" \
            bkgdTxBwUnits              "PERCENT" \
            bkgdTxDestPorts            "101/2 201/2" \
            bkgdTxEnabled              "0" \
            bkgdTxSrcPorts             "101/1 201/1" \
            bkgdTxpktLength            "100" \
            currentPkgName             "IpTvQualityofExperience" \
            currentPkgVersion          "0204103" \
            currentTestCase            "SUSTAINED_PERFORMANCE" \
            flapDuration               "15" \
            flapDurationBeforePeakLoad  "30" \
            flapGraphMaxWindow         "3600" \
            flapMaxDurationInHour      "72" \
            flapMeasureUpdateInterval  "5" \
            graphHistogramIntervalSize  "5" \
            graphSubscriberRepresentation  "POOL" \
            igmpGuiRepresentation      "FULL" \
            igmpIpRouterAlertOption    "1" \
            igmpLeaveGroupsAfterTest   "1" \
            igmpMsgInterval            "0" \
            igmpVersion                "IGMPv2" \
            igmpv3FilterMode           "EXCLUDE" \
            igmpv3Source               "None" \
            igmpv3SourceTypes          "None {Source Port Address} {Channels Source} {Explicit Address Range}" \
            igmpv3SrcRange             "192.1.1.1 24 100 1" \
            isDebugMode                "0" \
            isGenerateGraphHistogram   "1" \
            isGenerateGraphLatencyVsChannel  "1" \
            isGenerateGraphLatencyVsSubscribers  "1" \
            isTestingInBackToBack      "0" \
            joinDelayThreshold         "50" \
            leaveDelayThreshold        "50" \
            maxReportLines             "8000" \
            maxSubscriberPools         "512" \
            maxSubscribersPerPool      "512" \
            minSwVersion               "6.5" \
            multicastTxBandwidth       "50" \
            multicastTxBwUnits         "PERCENT" \
            multicastTxPattern         "CHANNELS_UNDER_TEST" \
            multicastTxToChannel       "3" \
            nextAvailableChannel       "23" \
            nextAvailableMcastGroup    "225.1.0.5" \
            startTestMode              "SETUP_RUN" \
            stopRoutingEngineAfterTest  "1" \
            stopTxAfterTest            "1" \
            subsPoolPhasedJoinInterval  "50" \
            testDistribution           "CONSTANT" \
            testStartTime              "1178334368" \
            testStopTime               "1178334441" \
            trickleTimeInSec           "4" \
        ] 
} 

#==========================================================================
#   A d d i t i o n a l   C l i e n t   D a t a   A r r a y s
#==========================================================================


array set ::TestApp::srcPortsData \
    [list \
            port-101/1                 "portType VIDEO_SERVER portEncap ETHERNET_FRAME subintfIdRange {1 1023} portIpAddr {104.1.1.2 104.1.1.1 24} portL2Addr {00:00:CC:00:00:00 00:00:00:00:00:00} backgroundEnabled 1" \
    ] 

array set ::TestApp::srcPoolsData \
    [list \
            pool-101/1/1               "name new_pool size 1 ipAddr {104.1.1.2 104.1.1.1 24 1} l2Addr {00:00:68:01:01:02 00:00:00:00:00:00} subintfIds {1 1}" \
    ] 

array set ::TestApp::subscriberPortsData \
    [list \
            port-101/2                 "portType ETHERNET portEncap ETHERNET_FRAME subintfIdRange {1 1023} portIpAddr {105.1.1.2 105.1.1.1 24} portL2Addr {00:00:CC:00:00:00 00:00:00:00:00:00} isVlanEnabled 1 videoVlanId -1 voiceVlanId -1 dataVlanId -1 isIgmpOnSubVlan 0" \
    ] 

array set ::TestApp::subscriberPoolsData \
    [list \
            pool-101/2/1               "name new_pool size 100 ipAddr {105.1.1.2 105.1.1.1 24 1} l2Addr {00:00:69:01:01:02 00:00:00:00:00:00} subintfIds {1 1} selectedChannels {{2 3 22 13}} watchTimes {{1000 1000 1000 1000}} deviceDelay 10 enabled 1 isSwitch 0 isDHCP 0 nSTBs 1 nPhone 1 nPC 1 phoneIpAddr 101.1.1.2 pcIpAddr 101.1.1.2 backgroundEnabled 1 isUniqueMacAddrGenerated 1 dhcpClientIdInfo {0 client 100 1 1}" \
    ] 

array set ::TestApp::channelTrafficProfile \
    [list \
            Custom1                    "ipBandwidth 50 bwUnits PERCENT ipPktLength 64 pduType IP pduPayloadFill RANDOM pduFillPattern 0xEF0000FE udpSrcDestPorts {5001 5001}" \
            Custom2                    "ipBandwidth 50 bwUnits PERCENT ipPktLength 64 pduType IP pduPayloadFill RANDOM pduFillPattern 0xEF0000FE udpSrcDestPorts {5001 5001}" \
            Custom3                    "ipBandwidth 500 bwUnits PPS ipPktLength 64 pduType IP pduPayloadFill RANDOM pduFillPattern 0xEF0000FE udpSrcDestPorts {5001 5001}" \
            MPEG2-HDTV                 "ipBandwidth 10 bwUnits MBPS ipPktLength 1344 pduType UDP pduPayloadFill RANDOM pduFillPattern 0xEF0000FE udpSrcDestPorts {5001 5001}" \
            MPEG2-SDTV                 "ipBandwidth 3 bwUnits MBPS ipPktLength 1344 pduType UDP pduPayloadFill RANDOM pduFillPattern 0xEF0000FE udpSrcDestPorts {5001 5001}" \
            MPEG4-SDTV                 "ipBandwidth 1.5 bwUnits MBPS ipPktLength 1344 pduType UDP pduPayloadFill RANDOM pduFillPattern 0xEF0000FE udpSrcDestPorts {5001 5001}" \
    ] 

array set ::TestApp::iptvChannels \
    [list \
            channel-13                 "name TV13 group 225.1.0.3 trafficProfile MPEG2-SDTV src {101/1 104.1.1.2 101/1/1} isChannelContentVideoClip 1 videoClipName Football_SD_NTSC_H264_NoAudio_2.19Mbps_06MB.ts maxMdiMlrThreshold 0 maxMdiDfThreshold 10 avgMdiMlrThreshold 0 avgMdiDfThreshold 10 vlanPriority 5 qosSelect DS tos {precedence 0 delay 0 throughput 0 reliability 0} ds {default_phb 0 class_selector_phb 8 assured_forwarding_phb 34 expedited_forwarding_phb 46 dsSelect assured_forwarding_phb}" \
            channel-2                  "name TV2 group 225.1.0.1 trafficProfile MPEG2-SDTV src {101/1 104.1.1.2 101/1/1} isChannelContentVideoClip 1 videoClipName Football_SD_NTSC_H264_NoAudio_2.19Mbps_06MB.ts maxMdiMlrThreshold 0 maxMdiDfThreshold 10 avgMdiMlrThreshold 0 avgMdiDfThreshold 10 vlanPriority 5 qosSelect DS tos {precedence 0 delay 0 throughput 0 reliability 0} ds {default_phb 0 class_selector_phb 8 assured_forwarding_phb 34 expedited_forwarding_phb 46 dsSelect assured_forwarding_phb}" \
            channel-22                 "name TV22 group 225.1.0.4 trafficProfile MPEG2-SDTV src {101/1 104.1.1.2 101/1/1} isChannelContentVideoClip 1 videoClipName Football_SD_NTSC_H264_NoAudio_2.19Mbps_06MB.ts maxMdiMlrThreshold 0 maxMdiDfThreshold 10 avgMdiMlrThreshold 0 avgMdiDfThreshold 10 vlanPriority 5 qosSelect DS tos {precedence 0 delay 0 throughput 0 reliability 0} ds {default_phb 0 class_selector_phb 8 assured_forwarding_phb 34 expedited_forwarding_phb 46 dsSelect assured_forwarding_phb}" \
            channel-3                  "name TV3 group 225.1.0.2 trafficProfile MPEG2-SDTV src {101/1 104.1.1.2 101/1/1} isChannelContentVideoClip 1 videoClipName Football_SD_NTSC_H264_NoAudio_2.19Mbps_06MB.ts maxMdiMlrThreshold 0 maxMdiDfThreshold 10 avgMdiMlrThreshold 0 avgMdiDfThreshold 10 vlanPriority 5 qosSelect DS tos {precedence 0 delay 0 throughput 0 reliability 0} ds {default_phb 0 class_selector_phb 8 assured_forwarding_phb 34 expedited_forwarding_phb 46 dsSelect assured_forwarding_phb}" \
    ] 

array set ::TestApp::unicastTrafficData \
    [list \
            ethMacFirstAddress         "00:00:10:00:00:01" \
            ethMacFirstLastAddress     "00:00:10:00:00:0a" \
            ethMacLastFirstAddress     "00:00:13:00:00:01" \
            ethMacLastLastAddress      "00:00:13:00:00:0a" \
            ethMacNumAddresses         "10" \
            ethMacPoolModifier         "1" \
            ethMacPortModifier         "1" \
            ethMacPrefix               "24" \
            linkModeEthEncapEnumList   "AGT_ETHERNET_FRAME AGT_ETHERNET_802_3_SAP_FRAME AGT_ETHERNET_802_3_LLC_SNAP_FRAME" \
            linkModeEthEncapList       {"Ethernet II" "802.3 SAP" "802.3 LLC/SNAP"} \
            linkModeEthJumboEnabled    "0" \
            linkModeEthSpeedEnumList   "AGT_ETHERNET_LINK_AUTONEGOTIATE AGT_ETHERNET_LINK_10BASET_FULLDUPLEX AGT_ETHERNET_LINK_10BASET_HALFDUPLEX AGT_ETHERNET_LINK_100BASET_HALFDUPLEX AGT_ETHERNET_LINK_100BASET_HALFDUPLEX" \
            linkModeEthSpeedList       {"Auto" "10 Mb/s full duplex" "10 Mb/s half duplex" "100 Mb/s full duplex" "100 Mb/s half duplex"} \
            linkModeEthernetArp        "Disable" \
            linkModeEthernetEncap      "Ethernet II" \
            linkModeEthernetSpeed      "Auto" \
            maxNumPorts                "64" \
            meshAddressType            "IPv4" \
            meshAddressTypeList        {"Ethernet MAC" "IPv4" "Route Pool"} \
            meshBaseName               "Mesh" \
            minSwVersion               "6.3" \
            sinkPortFramingModeList    "unknown unknown" \
            sinkPortHandleList         "" \
            sinkPortNameList           "102/1 102/2" \
            sinkPortTypeList           "unknown unknown" \
            srcPortFramingModeList     "unknown unknown" \
            srcPortHandleList          "" \
            srcPortNameList            "101/1 101/2" \
            srcPortTypeList            "unknown unknown" \
            sutType                    "ROUTER" \
            testDuration               "3" \
            testIsBidirectional        "0" \
            testRemoveOldTraffic       "1" \
            testStartTime              "1178326293" \
            testStopTime               "1178326293" \
            testTopology               "FullMesh" \
            tstIpv4FirstAddress        "100.0.1.2" \
            tstIpv4FirstLastAddress    "100.0.1.11" \
            tstIpv4LastFirstAddress    "100.0.2.2" \
            tstIpv4LastLastAddress     "100.0.2.11" \
            tstIpv4NumAddresses        "10" \
            tstIpv4PoolModifier        "1" \
            tstIpv4PortModifier        "1" \
            tstIpv4Prefix              "24" \
            txBandwidth                "50" \
            txBwType                   "% of Max" \
            txBwTypeList               " {Frames/s} {Mb/s} {% of Max} " \
            txBwUnits                  "PERCENT" \
            txBwUpdateInProgress       "0" \
            txExplicitLoadValue        "0" \
            txFrameLengthIncrement     "1" \
            txFrameLengthMax           "1500" \
            txFrameLengthMin           "46" \
            txFrameLengthMode          "AGT_PACKET_LENGTH_MODE_IP_PACKETS" \
            txFrameLengthType          "Fixed" \
            txPayloadFill              "Incrementing (8-bit: 00 01 02 03...)" \
            txPayloadFillEnumList      "AGT_PAYLOAD_FILL_TYPE_8_BIT_INCREMENT AGT_PAYLOAD_FILL_TYPE_16_BIT_INCREMENT AGT_PAYLOAD_FILL_TYPE_RANDOM AGT_PAYLOAD_FILL_TYPE_REPEATING AGT_PAYLOAD_FILL_TYPE_REPEATING AGT_PAYLOAD_FILL_TYPE_REPEATING AGT_PAYLOAD_FILL_TYPE_REPEATING" \
            txPayloadFillList          {"Incrementing (8-bit: 00 01 02 03...)" "Incrementing (16-bit: 00 01 00 02...)" "Random" "00 00 00 00..." "AA 55 AA 55..." "FF 00 FF 00..." "FF FF FF FF..."} \
            txPayloadFillPatternList   "0 0 0 0x00000000 0xAA55AA55 0xFF00FF00 0xFFFFFFFF" \
            txPduType                  "IPv4" \
            txPduTypeList              " Ethernet IPv4 UDPv4 TCPv4 " \
            txRefreshTimerId           "0" \
            txSliderValue              "50" \
            txStreamEnumList           " DESTINATION_ADDRESS SOURCE_ADDRESS AUTO " \
            txStreamType               "Per destination address" \
            txStreamTypeList           {"Per destination address" "Per source address" "Auto"} \
            txTestPayloadEnabled       "1" \
            txTestProfileList          "" \
            txUdpDstPort               "80" \
            txUdpSrcPort               "80" \
            useDefaultAddress          "1" \
            vlanEnabledFlag            "1" \
    ] 

array set ::TestApp::srcSinkRecords \
    [list \
    ] 

array set ::TestApp::backgroundTrafficProfile \
    [list \
            data-downstream            "name {Data Dn Stream} type DATA dir 0 vlanPriority 0 codec { } bandwidth 300 packetLength 1500 pduType TCP dstPort 8001 qosSelect DS tos {precedence 0 delay 0 throughput 0 reliability 0} ds {default_phb 0 class_selector_phb 0 assured_forwarding_phb 10 expedited_forwarding_phb 46 dsSelect expedited_forwarding_phb}" \
            data-upstream              "name {Data Up Stream} type DATA dir 1 vlanPriority 0 codec { } bandwidth 4 packetLength 40 pduType TCP dstPort 8000 qosSelect DS tos {precedence 0 delay 0 throughput 0 reliability 0} ds {default_phb 0 class_selector_phb 0 assured_forwarding_phb 10 expedited_forwarding_phb 46 dsSelect expedited_forwarding_phb}" \
            voice-downstream           "type VOICE name {Voice Dn Stream} dir 0 vlanPriority 5 codec G.728 bandwidth 32 packetLength 80 pduType UDP dstPort 5001 qosSelect DS tos {precedence 2 delay 0 throughput 1 reliability 1} ds {default_phb 0 class_selector_phb 0 assured_forwarding_phb 10 expedited_forwarding_phb 46 dsSelect default_phb}" \
            voice-upstream             "type VOICE dir 1 name {Voice Up Stream} vlanPriority 5 codec G.728 bandwidth 32 packetLength 80 pduType UDP dstPort 5000 qosSelect DS tos {precedence 2 delay 0 throughput 1 reliability 1} ds {default_phb 0 class_selector_phb 0 assured_forwarding_phb 10 expedited_forwarding_phb 46 dsSelect default_phb}" \
    ] 

array set ::TestApp::videoClipProfiles \
    [list \
            Animals_VOD_NTSC_H264_AC3Audio_2.79Mbps_06MB.ts  "pduType UDP udpSrcDestPorts {5001 5001}" \
            Football_SD_NTSC_H264_NoAudio_2.19Mbps_06MB.ts  "pduType UDP udpSrcDestPorts {5001 5001}" \
    ] 

array set ::TestApp::voiceCodecProfile \
    [list \
            G.711                      "encapsulation G.711/RTP/UDP/IPv4 packetLength 200 bandwidth 80 rtpPayloadType 0" \
            G.723.1                    "encapsulation G.723.1/RTP/UDP/IPv4 packetLength 64 bandwidth 16.8 rtpPayloadType 4" \
            G.726                      "encapsulation G.726/RTP/UDP/IPv4 packetLength 100 bandwidth 53.3 rtpPayloadType dynamic" \
            G.728                      "encapsulation G.728/RTP/UDP/IPv4 packetLength 80 bandwidth 32 rtpPayloadType 15" \
            G.729                      "encapsulation G.729/RTP/UDP/IPv4 packetLength 60 bandwidth 28 rtpPayloadType 18" \
    ] 
